/**
 * @author       : Shannon Eddio <youremail@example.com>
 * @contributor  : Christian Noel Reyes <darkcolonist@gmail.com>
 * @title        : Utility Helper Javascript
 * @desciption   : A Utility helper that does all the messy work.
 * @dependencies : jquery v1.9.1
 * @date         : 2013-11-15
 */

/**
 * the Util JSON
 * @type type
 */

util = {
  url : function(segments){
    if(segments == null){ // classic if..then statement
      segments = "";
    }    
    return $("[name=urlBase]").val() + segments;
  },
          
  current_url : function(){   
    return $("#current_url").val();
  },
          
  user : function(){   
    return $("[name=modUser]").val();
  },
          
  ucfirst : function(str){
    str += '';
    var f = str.charAt(0).toUpperCase();   
    return f + str.substr(1);
  },
          
  another_useful_function : function(message){
    console.log(message);
    alert("hello world!");
  },

  /**
   * create an overlay wait container on top of the selector
   * @param  string selector
   * @return void
   */
  wait  : function(selector, options){
    var defaultOptions = {
      "message" : "working...",
      "showLoadingImage" : true,
      "animate" : true,
      "animation" : "fade",
      "speed" : "slow"
    };

    var options = $.extend(defaultOptions, options);

    var objSet = $(selector);

    var success = 0;

    if(objSet.length == 0)
      return "no objects selected";
    else if(objSet.length == 1){
      success = util._waitApplyToObject(objSet, options);
    }else{
      for (var i = 0; i < objSet.length; i++) {
        success += util._waitApplyToObject(objSet[i], options);
      };
    }

    return success + " objects waiting.";
  },
  _waitApplyToObject : function(object, options){
    var object = $(object);

    if(object.data("waiterOverlay") != null){
      return 0;
    }

    var overlayHTML = 
      "<div class='waiterOverlay'>\
        <span></span>\
      </div>";

    var overlay = $(overlayHTML).css({
      "width"       : object.outerWidth(),
      "height"      : object.outerHeight(),
      "left"        : object.position().left,
      "top"         : object.position().top,
      "z-index"     : object.css("z-index") == "auto" ? 1 : object.css("z-index")+1,
      "position"    : "absolute",
      "text-align"  : "center"
    });

    if(options.animate){
      overlay.hide();
    }

    overlay.find("span")
      .text(options.message)
      .css({
        "line-height" : object.outerHeight() + "px"
      });

    if(options.showLoadingImage){
      var loaderImage = $("<img>");
      loaderImage.attr("src", util.url("images/chat-loader.gif"))
        .attr("alt", "loader")
        .css({
          "vertical-align" : "middle",
          "padding-right"  : "5px"
        });
      overlay.find("span").prepend(loaderImage);
    }

    object.data("waiterOverlay", overlay);
    object.after(overlay);

    if(options.animate){
      overlay.effect(options.animation, options.speed);
    }

    return 1;
  },
  unwait : function(selector, options){
    var defaultOptions = {
      "animate" : true,
      "animation" : "fade",
      "speed" : "slow"
    };

    var options = $.extend(defaultOptions, options);

    var objSet = $(selector);

    var objCounter = objSet.length;
    var objSuccess = 0;

    for (var i = 0; i < objSet.length; i++) {
      var obj = $(objSet[i]);

      var overlay = obj.data("waiterOverlay");

      if(overlay != null){
        overlay.finish().effect(options.animation, options.speed, function(){
          this.remove();
        });
        objSuccess += 1;
        obj.data("waiterOverlay", null);
      }
    };

    return objCounter + " found, " + objSuccess + " instances removed.";
  },
  
  get_loader: function(loader_style){
    var loader_html = '';
    
    switch (loader_style){
      case "icon":
        loader_html = '<img class="ajaxLoader" src="' + util.url("images/icn_loader.gif") + '" alt="Loading&#8230;" />';
        break;
      case "image":
        loader_html = '<img class="ajaxLoader" src="' + util.url("images/ajax-loader.gif") + '" alt="Loading&#8230;" />';
        break;
      default:
          loader_html = '<div class="loader_panel"><p>Processing, please wait...<p/><p><img style="float:none" src="'
                  +util.url("images/ajax-loader.gif")+
                  '" alt="Loading&#8230;" title="Loading..." /><p/></div>';
    }
    return loader_html;
  }
};