$(document).ready(function(){
  pnlTalents.init();
});

pnlTalents = {
   init : function(){
    pnlTalents.save();
    pnlTalents.initEdit();
    pnlTalents.edit();
    pnlTalents.initPhoto();
    pnlTalents.addPhotos();
    pnlTalents.deleteTalent();
    pnlTalents.deletePhoto();
  },
 save: function () {
        $("form#frmTalents").on("submit",function(e){
            e.preventDefault();
            var formData = new FormData($(this)[0]);
                $.ajax({
                    type: "post",
                    url: util.url("admin/talents/save"),
                    data: formData,
                    success: function (data) {
                      if(data == "Error"){
                          toastr.error("", "Error!");
                      }else{
                        toastr.success("Talent Profile Saved", "Success!");
                      }
                    },
                    cache: false,
                    contentType: false,
                    processData: false
                });//end of ajax          
    
        });

    },


    edit: function () {
        $(document).on("submit",'#frmEditTalent',function(e){
            e.preventDefault();
            var formData = new FormData($(this)[0]);
                $.ajax({
                    type: "post",
                    url: util.url("admin/talents/edit/" + $("#talent_id").val()),
                    data: formData,
                    success: function (data) {
                      if(data == "Error"){
                          toastr.error("", "Error!");
                      }else{
                        toastr.success("Talent Profile Updated", "Success!");
                        location.reload();
                      }
                    },
                    cache: false,
                    contentType: false,
                    processData: false
                });//end of ajax          
    
        });

    },

    addPhotos: function () {
        $(document).on("submit",'#frmTalentPhotos',function(e){
            e.preventDefault();
            var formData = new FormData($(this)[0]);
                $.ajax({
                    type: "post",
                    url: util.url("admin/talents/add_photos/" + $("#talent_id").val()),
                    data: formData,
                    success: function (data) {
                      if(data == "Error"){
                          toastr.error("", "Error!");
                      }else{
                        toastr.success("Photos Uploaded", "Success!");
                      }
                    },
                    cache: false,
                    contentType: false,
                    processData: false
                });//end of ajax          
    
        });

    },

    initEdit: function () {
        $(document).on('click','#edit_talent',function(e){
        $("#talent_id").val($(this).attr("data-id"));
        console.log($(this).attr("data-id"))
            $.ajax({
                    type: "post",
                    url: util.url("admin/talents/edit_form/" + $("#talent_id").val()),
                    success: function (data) {
                      $("#frmEdit").html(data);
                    },
                    cache: false,
                    contentType: false,
                    processData: false
                });//end of ajax          
        });

    },

    initPhoto: function () {
        $(document).on('click','#add_photo',function(e){
        $("#talent_id").val($(this).attr("data-id"))
            $.ajax({
                    type: "post",
                    url: util.url("admin/talents/add_photos_form/" + $("#talent_id").val()),
                    data: "",
                    success: function (data) {
                      $("#frmImages").html(data);
                    },
                    cache: false,
                    contentType: false,
                    processData: false
                });//end of ajax          
        });

    },

  deleteTalent: function(){
   $(document).on('click','#delete_talent',function (e) {
     e.preventDefault();
     var r = confirm("Are you sure you want to delete this talent?");
            if (r == true) {
                $.ajax({
                    type: "get",
                    url: util.url('admin/talents/delete_talent/') + $(this).attr('data-id'),
                    success: function (data) {
                       toastr.success("Talent deleted.", "Successful!");

                       location.reload();
                    }
                });//end of ajax 
            } 
        });

  },

  deletePhoto: function(){
   $(document).on('click','#delete_photo',function (e) {
     e.preventDefault();
     var r = confirm("Are you sure you want to delete this photo?");
            if (r == true) {
                $.ajax({
                    type: "get",
                    url: util.url('admin/talents/delete_photo/') + $(this).attr('data-id'),
                    success: function (data) {
                       toastr.success("Photo deleted.", "Successful!");
                        $("#add_photo").trigger( "click" );
                    }
                });//end of ajax 
            } 
        });

  },
};
