<?php defined('SYSPATH') OR die('No direct access allowed.');
class Talents_Controller extends Home_Wrapper_Template_Controller {

  function  __construct() {
    parent::__construct();

    $this->template->title = "Talents";
    $this->template->styles = html::stylesheet("styles/bootstrap.css");
    $this->template->styles .= html::stylesheet("styles/spectrumtalent.css");
    $this->template->styles .= html::stylesheet("styles/fontawesome-free/css/all.min.css");
    $this->template->styles .= html::stylesheet("styles/slick.css");
    $this->template->scripts = html::script("scripts/jquery-3.3.1.slim.min.js");
     $this->template->scripts .= html::script("scripts/slick.js");
    $this->template->scripts .= html::script("scripts/bootstrap.min.js");
    $this->template->scripts .= html::script("scripts/popper.min.js");
  //  $this->template->scripts .= html::script("scripts/toastr.min.js");

  }

  public function lists($state,$category){
    $talents = TblTalents::get_talents($state,$category);
    $st = Doctrine::getTable("TblStates")->find($state);
    $cat = Doctrine::getTable("TblCategories")->find($category);
    $params = array(
      "talents" => $talents,
      "state" => $st->name,
      "category" => $cat->name,
    );

    $this->template->body = view::factory("content_talent_list", $params)->render();
  }

  public function details($talent_id){
    $talent = Doctrine::getTable("TblTalents")->find($talent_id);

    $params = array(
      "talent" => $talent,
    );

        $this->template->body = view::factory("content_celebrity_details", $params)->render();

    
  }

  public function model_details($talent_id){
    $talent = Doctrine::getTable("TblTalents")->find($talent_id);

    $params = array(
      "talent" => $talent,
    );

        $this->template->body = view::factory("content_talent_details", $params)->render();

    
  }

}