<?php

defined('SYSPATH') or die('No direct script access.');

class Talents_Controller extends Protected_Pages_Template_Controller {

  public function __construct() {
    parent::__construct();

        $this->template->title = "Dashboard";
        $this->template->styles = html::stylesheet("styles/bootstrap.css");
        $this->template->styles .= html::stylesheet("styles/spectrumtalent.css");
        $this->template->styles .= html::stylesheet("styles/fontawesome-free/css/all.min.css");
        $this->template->styles .= html::stylesheet("styles/slick.css");
        $this->template->styles .= html::stylesheet("styles/dashboard/style.css");
        $this->template->styles .= html::stylesheet("styles/toastr.min.css");
        $this->template->scripts = html::script("scripts/jquery-3.3.1.slim.min.js");
        $this->template->scripts .= html::script("scripts/jquery-1.9.1.js");
         $this->template->scripts .= html::script("scripts/slick.js");
        $this->template->scripts .= html::script("scripts/bootstrap.min.js");
        $this->template->scripts .= html::script("scripts/popper.min.js");
        $this->template->scripts .= html::script("scripts/toastr.min.js");
        $this->template->scripts .= html::script("scripts/pnlTalents.js");
        $this->template->scripts .= html::script("scripts/util.js");
  }

  public function index() {
    $this->template->title = "Profile";
    $this->template->body->title = "";

    if(!Session::instance()->get("user_id")){
      url::redirect('/login');
    }
    $user = Doctrine::getTable("TblUsers")->find(Session::instance()->get("user_id"));

    $params = array(
      "user" => $user,
      "states" => util::get_states_dropdown(),
      "categories" => util::get_categories_dropdown(),
    );
    
    $this->template->body->content = View::factory("admin/content_talents", $params)->render();
  }

public function save(){
  $this->auto_render = false;
  $uploadDir = url::base().'/uploads/';
  $post = $_POST;

  $files = Validation::factory($_FILES)
          ->add_rules('file', 'upload::valid', 'upload::type[gif,jpg,png,jpeg]');
  
  if(!$_FILES['video']['name'] == ""){
     $vidfilename = $_FILES['video']['name'];

      move_uploaded_file($_FILES['video']['tmp_name'], DOCROOT.'uploads/'.$vidfilename);
      
      $video_file = 'uploads/'.$vidfilename;

  }

    if ($files->validate())
    {
      // Temporary file name
      $filename = upload::save('file');
      
      // Resize, sharpen, and save the image
      Image::factory($filename)
        ->save(DOCROOT.'uploads/'.basename($filename));

        $category = Doctrine::getTable("TblCategories")->find($post["category_id"]);
        $state = Doctrine::getTable("TblStates")->find($post["state_id"]);

        if(!$post["show_reel"] == ""){
          $show_reel = $post["show_reel"];
        }else{
          $show_reel = $video_file;
        }
        $talent = new TblTalents();
        $talent->name = $post["name"];
        $talent->title = $post["title"];
        $talent->description = $post["bio"];
        $talent->category_name = $category->name;
        $talent->category_id = $category->id;
        $talent->img_link = "uploads/".basename($filename);
        $talent->state_id = $state->id;
        $talent->state = $state->name;
        $talent->show_reel =  $show_reel;
        $talent->bio_link = $post["resume"];
        $talent->date_created = gmdate("Y-m-d H:i:s");
        $talent->save();

  }
}

public function edit($id){
  $this->auto_render = false;
  $uploadDir = url::base().'/uploads/';
  $post = $_POST;
$talent =  Doctrine::getTable("TblTalents")->find($id);


if($_FILES['file']['name'] != ""){
    $files = Validation::factory($_FILES)
          ->add_rules('file', 'upload::valid', 'upload::type[gif,jpg,png]', 'upload::size[1M]');

 
      // Temporary file name
      $filename = upload::save('file');
      
      // Resize, sharpen, and save the image
      Image::factory($filename)
        ->save(DOCROOT.'uploads/'.basename($filename));

    $file =  "uploads/".basename($filename);
}else{
      $file = $talent->img_link;
    }

        $category = Doctrine::getTable("TblCategories")->find($post["category_id"]);
        $state = Doctrine::getTable("TblStates")->find($post["state_id"]);

        
        $talent->name = $post["name"];
        $talent->title = $post["title"];
        $talent->description = $post["bio"];
        $talent->category_name = $category->name;
        $talent->category_id = $category->id;
        $talent->img_link = $file;
        $talent->state_id = $state->id;
        $talent->state = $state->name;
        $talent->show_reel = $post["show_reel"];
        $talent->bio_link = $post["resume"];
        $talent->date_created = gmdate("Y-m-d H:i:s");
        $talent->save();

  }

  public function get_items($category_id, $state_id){
   $this->template->title = "Talents";
    $this->template->body->title = "";
    $items = TblTalents::get_list($category_id, $state_id);
    $category = Doctrine::getTable("TblCategories")->find($category_id);
    
    $params = array(
      "category" => $category->name,
      "items" => $items,
    );
    $this->template->body->content = view::factory("admin/content_talent_list", $params)
        ->render();

  }


  public function edit_form($id){
     $this->auto_render = false;
     $talent = Doctrine::getTable("TblTalents")->findOneById($id);
     $params = array(
      "id" => $id,
      "data" => $talent->toArray(),
      "states" => util::get_states_dropdown(),
      "categories" => util::get_categories_dropdown(),
    );
    
     return view::factory("admin/content_talent_form", $params)
        ->render(true);
  } 

  public function add_photos_form($id){
     $this->auto_render = false;
     $talent = Doctrine::getTable("TblTalents")->findOneById($id);
     $params = array(
      "id" => $id,
      "data" => $talent->toArray()
    );
    
     return view::factory("admin/content_photos_form", $params)
        ->render(true);
  }

  public function add_photos($id){
    $this->auto_render = false;
 $countfiles = count($_FILES['image']['name']);
    for($i=0;$i<$countfiles;$i++){
      $filename = $_FILES['image']['name'][$i];
 
  // Upload file

      move_uploaded_file($_FILES['image']['tmp_name'][$i], DOCROOT.'uploads/'.$filename);
      
      $file = 'uploads/'.$filename;

    $talent_photo = new TblTalentFiles();
     $talent_photo->talent_id = $id;
     $talent_photo->link = $file;
     $talent_photo->save();
    }

     
    }

     public function delete_talent($id){
    $this->auto_render = false;

    $talent = Doctrine::getTable("TblTalents")->find($id);
    $talent->delete();

  }

   public function delete_photo($id){
    $this->auto_render = false;

    $talent = Doctrine::getTable("TblTalentFiles")->find($id);
    $talent->delete();

  }
}
