<?php defined('SYSPATH') OR die('No direct access allowed.');
class Util {

  static function app_title($segment = null) {
    $title = Kohana::config("application.title");
    $title .= " v". Kohana::config("application.version");

    $title .= $segment == null ? null : " - " . $segment;

    return $title;
  }

   static function user_has_permission($permission, $permissions = null){
    if($permissions == null)
      $permissions_json = Session::instance()->get("permissions");
    else
      $permissions_json = $permissions;
    $permissions_json = str_replace("[]", "", $permissions_json);
    $permissions_arr = json_decode($permissions_json, true);
    if(empty($permissions_arr[$permission]) == false)
      return true;

    return false;
  }

    static function get_states_dropdown(){
    $states_model = new TblStates();
    $states_model = $states_model->get_dropdown();

    foreach($states_model as $key => $state_dd)
      $dropdown[$key] = $state_dd;

    unset($dropdown[0]);

    return $dropdown;
  }

  static function get_categories_dropdown(){
    $category_model = new TblCategories();
    $category_dropdown = $category_model->get_dropdown();

    foreach($category_dropdown as $key => $category_dd)
      $dropdown[$key] = $category_dd;

    unset($dropdown[0]);

    return $dropdown;
  }

  static function get_product_type_dropdown(){
    $product_type_model = new TblProductType();
    $product_type_dropdown = $product_type_model->get_dropdown();

    foreach($product_type_dropdown as $key => $product_dd)
      $dropdown[$key] = $product_dd;

    unset($dropdown[0]);

    return $dropdown;
  }

   static function get_table_options_dropdown(){
    $ids = TblTables::get_existing_table_ids();

       $table_option_model = new TblTableOptions();
    $to_dropdown = $table_option_model->get_dropdown($ids);

    foreach($to_dropdown as $key => $to_dd)
      $dropdown[$key] = $to_dd;

    unset($dropdown[0]);

    return $dropdown;
  }


}
